//	CEntry.h

#ifndef _H_CEntry
#define _H_CEntry

#ifndef __GNUC__
	#include <Drag.h>
#endif

#include "CCopyFile.h"
#include "GenStructs.h"
#include "ADFS_Icons.h"
#include "O.h"
#include "FileSystemTypes.h"
#include "CFinderWindowHeader.h"
#include "CEntryArray.h"

#ifndef ulong
	typedef	unsigned long	ulong;
	typedef	unsigned short	ushort;
#endif

extern	DateTimeRec		g_nullDateTime;

typedef ushort	EntryIndex;

typedef enum {
	ADFS_File_NONE, 
	
	ADFS_File_BINARY, 
	ADFS_File_BASIC, 
	ADFS_File_INTBASIC, 
	ADFS_File_TEXT, 
	ADFS_File_AWP, 

	ADFS_File_HGR, 
	ADFS_File_DHGR_DAZ, 
	ADFS_File_DHGR_BEAGLE, 

	ADFS_File_NUMTYPES
} ADFS_FileType;

enum	{
	ADFS_TA_Iterate_MOVE_FILE_DOWN = TA_Iterate_NUMTYPES, 
	ADFS_TA_Iterate_MOVE_FILE_UP, 
	
	ADFS_TA_Iterate_NUMTYPES
};

class CEntry;
class CDialogGetInfo;
//class O_CTopic;
class CFinderWindow;
class CFolderWindow;
class CDialogGetInfo;
class COffscreen;

typedef enum {
	ADFS_Preview_NONE, 
	
	ADFS_Preview_TEXT, 
	ADFS_Preview_PIC, 
	
	ADFS_Preview_NUMTYPES
} ADFS_PreviewType;

typedef struct {
	ADFS_PreviewType	type;
	
	union {
		Handle		textH;
		COffscreen	*offsP;
	} u;
} ADFS_PreviewRec;

#define		kDragFlavorTypeADFS			'ADFS'

CEntry		*GetTopicEntry(O_CTopic *topic);
O_CTopic	*GetEntryTopic(CEntry *entry);

extern	DateTimeRec		g_nullDateTime;

#define		DateIsNull(_dP)					\
	((_dP)->year == g_nullDateTime.year		\
	&& (_dP)->month == g_nullDateTime.month	\
	&& (_dP)->day == g_nullDateTime.day)

#define		TimeIsNull(_dP)							\
	((_dP)->hour == g_nullDateTime.hour				\
	&& (_dP)->minute == g_nullDateTime.minute		\
	&& (_dP)->second == g_nullDateTime.second		\
	&& (_dP)->dayOfWeek == g_nullDateTime.dayOfWeek)

#define		DateTimeIsNull(_dtP)	(DateIsNull(_dtP) && TimeIsNull(_dtP))


class CEntry {

	public:

	OSErr			IEntry(
		CDisk				*cDisk, 
		CFolder				*cParentFolder, 
		FSObjectType		type, 
		DiskLocSpecUnion	diskLoc, 
		EntryIndex			diskLocDirEntryIndex,	//	relative to cur dir sector
		EntryIndex			directoryIndex			//	relative to entire directory
	);
	
	virtual	void	Dispose(void);		
	virtual	OSErr	Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	virtual	OSErr	UnDelete(Boolean recursiveB = FALSE, CDialogCopy *copyP0 = NULL);
	
	virtual	Boolean	IsForked(void);
	virtual	OSErr	GetForkInfo(CCT_ForkInfo *forkInfoP);
	virtual	OSErr	SetForkInfo(CCT_ForkInfo *forkInfoP);
	
	virtual	void	UpdateGlobals(void);

	virtual	OSErr	CountRecurse(Boolean deletedB, ulong *totalL);

	virtual	OSErr		EntryPane_CB_EntryArray(
		TA_IterateType taType, TA_IterateData *cbData);

	virtual	void	Select(Boolean selectedB, Boolean drawB);
	virtual	void	SelectAll(Boolean selectedB, Boolean drawB);
	virtual	Boolean	IsSelected(void);

	static	Err		S_EntryDispatchCB(
		O_TopicRefP			topicRef, 
		O_CBType			cbType, 
		O_CBDataP			cbData
	);

	virtual	Err		EntryDispatchCB(
		O_CBType			cbType, 
		O_CBDataP			cbData
	);

	virtual	CFinderWindow		*GetMyWindow(void);
	virtual	CFinderWindow		*GetEnclosingWindow(void);

	virtual	void			GetStatRects(
		ADFS_StatType	statType, 
		Rect			*statRect, 
		Rect			*statItemRect,	//	ONLY for non strings!
		Rect			*statBufRect	//	just the buffer area (to the right)
	);
	virtual	char			*GetStatString(
		ADFS_StatType	statType, 
		char			*buf, 
		Rect			*statRect, 
		Rect			*statItemRect,	//	ONLY for non strings
		Rect			*statBufRect	//	just the buffer area (to the right)
	);
	
	virtual	char			*GetStatStringInfo(
		ADFS_StatType	statType, 
		char			*buf, 
		Rect			*statRect, 
		Rect			*statStrRect,
		Rect			*statLeftBufRect, 
		Rect			*statRightBufRect
	);
	
	virtual	void			Draw(void);
	virtual	void			DrawStat(ADFS_StatType rectType);

	virtual	ADFS_StatType	HitTest(
		Point		thePoint, 
		Rect		*theRect0
	);
	
	virtual	void			ApplyToItems(
		O_IterateType	iterateType, 
		O_CBType		cbType, 
		void			*cbData
	);
	
	#define	ApplyToSelection(_ct, _cd)		ApplyToItems(O_Iterate_SELECTED, _ct, _cd)
	#define	ApplyToOnScreenItems(_ct, _cd)	ApplyToItems(O_Iterate_ONSCREEN, _ct, _cd)

	virtual	Boolean			IsAncestorSelected(void);

	void			DisposeEntryAlloc(Gen_EntryAlloc *sectorListP);
	virtual	OSErr	GetEntryAlloc(
		Boolean				getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	virtual	void			DoClick(Point thePoint, long modifiers);

	virtual	char			*GetName(char *buf);
	virtual	void			SetName(char *buf);

	virtual	Boolean			IsTrashed(void);
	virtual	void			SetTrashed(Boolean trash);
	
	virtual	Boolean			IsLocked(void);
	virtual	void			SetLocked(Boolean lock);	
	
	virtual	DateTimeRec		*GetCreatedTime(DateTimeRec *dt);
	virtual	char			*GetCreatedTimeString(char *buf);
	virtual	void			SetCreatedTime(DateTimeRec *dt);

	virtual	DateTimeRec		*GetModifiedTime(DateTimeRec *dt);
	virtual	char			*GetModifiedTimeString(char *buf);
	virtual	void			SetModifiedTime(DateTimeRec *dt);

	virtual	ulong			GetLogicalSize(void);
	virtual	void			SetLogicalSize(ulong size);
		
	virtual	ulong			GetPhysicalSize(void);
	virtual	void			SetPhysicalSize(ulong size);
	
	virtual	char			*GetDescription(char *buf);
	
	virtual ADFS_IconType	GetIconType(void);
	
	virtual	void			SetFileType_ProEquiv(Byte proType);
	virtual	ushort			GetFileType_ProEquiv(void);
	
	virtual	void			SetFileType(Byte fileType);
	virtual	ushort			GetFileType(void);

	virtual	ushort			GetAuxType(void);
	virtual	void			SetAuxType(ushort auxType);
		
	virtual	void			GetBlitRgn(RgnHandle theRgn);
	virtual	void			GetNameAndIconRgn(RgnHandle theRgn);
	virtual	OSErr			DragItem(EventRecord *theEvent);

	virtual	OSErr			CanAcceptFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		Boolean			*isGoodFlavorB);

	virtual	OSErr			DragReceiveFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		void			*data);

	void			GetMacTypeAndCreator(
		OSType	*fileType, 
		OSType	*fileCreator);

	virtual	ulong		ADFS_GetBufSize(void);
	virtual	OSErr		ADFS_Open(
		ADFS_IOType	ioType, 
		Boolean		resForkB, 
		char		**bufferP, 
		ulong		*bufSize);
	
	virtual	OSErr		ADFS_Read(ushort *bytesRead);
	virtual	OSErr		ADFS_Write(ushort *bytesWritten);
	virtual	OSErr		ADFS_Close(void);

	virtual	OSErr		ADFS_SetPendingCopy(
		CCT_CopyType	sourceType, 
		CCT_CopyType	destType, 
		void			*opDataP);

	static	void		ADFS_DoPendingCopyCB(void);

	virtual	OSErr		AddToDragRef(TA_Iterate_ADD_TO_DRAG_Data *dragData);

	OSErr				ADFS_DragSendDataProc(
		DragRef			theDrag, 
		DragItemRef		itemRef, 
		FlavorType		flavorType);

	void				LogName(void);
	void				InvalStat(ADFS_StatType statType);
	
	virtual	CFolder		*GetParentFolder(void);
	virtual	CEntry		*GetParent(void);	//	could be a disk
	virtual	void		DrawIcon(IconTransformType transform, Rect *theRect);

	virtual	void		SetTimeStamps(DateTimeRec *creDate, DateTimeRec *modDate);
	virtual	void		GetTimeStamps(DateTimeRec *creDate, DateTimeRec *modDate);

	virtual	void		GetAccessBits(Gen_AccessBits *bits);
	virtual	void		SetAccessBits(Gen_AccessBits *bits);

	virtual	void			SetTwirled(Boolean twirledB);	
	virtual	Boolean			GetTwirled(void);

	virtual	char		*GetWhereString(char *buf256);
	virtual	char		*GetStorageStr(char *buf256);

	CRenameTextEdit		*IsThisRename(void);
	virtual	Boolean		CanRename(void);
	virtual	void		Rename(void);
	static	void		CEntry_S_CB_FinishRename(void *cbData);
	virtual	void		FinishRename(void);
	
	void		Hilight(Boolean hilightedB);
	Boolean		IsHilighted(void);

	virtual	OSErr		Duplicate(void);
	virtual	CEntry		*NextEntry(void);

	virtual	void		GetPreview(ADFS_PreviewRec *previewRecP);

	virtual	Boolean		IsDeleted(void);
	virtual	Boolean		IsTranslatable(void);
	virtual	Boolean		IsGraphic(void);

	virtual	void		Open(void);
	
	virtual	OSErr		ToggleDeletedFiles(void);

	O_TopicIndex		GetEntryIndex(void);

	virtual	OSErr		UpdateSort(Boolean recursiveB = FALSE);

	virtual	OSErr		Reorder(
		O_TopicIndex	oldIndex,
		O_TopicIndex	newIndex);

	/***********************
		how many bytes
		
		files:
			logical: 	the program expects
			physical: 	the disk uses to store the file
						plus size of any related extent structures
						
		folders and disks:
			logical:	sum logical size each element recursive
			physical:   sum physical plus size of directory and extent structures
	*/

	/*
	//	heirarchy related
	EntryIndex		GetNativeIndex(void);	//	zero based, get -1 for disk
	EntryIndex		GetOutlineIndex(void);
	
	CEntryUnion		GetNext(void);
	CEntryUnion		GetPrevious(void);
	
	//	private
	void			Flush(void);	//	all the SET calls call this
	*/
	
	/************************************/
	//	caches
	CDiskUnion				i_cDisk;			//	for CDisk, a self pointer  :)
	FSObjectType			i_type;				//	folder, file, disk
	Boolean					i_disposingB;
	ADFS_FileType			i_fileType;			//	bas, bin, pict, AW.  iff i_type == file
	ulong					i_physical_sizeL;
	ulong					i_logical_sizeL;
	
	//	all this stuff prolly belongs under CFile
	ADFS_IOType				i_ioType;
	Boolean					i_resForkB;			//	are we currently dealing with the res fork?
	ulong					i_eof;
	ulong					i_filePos;			//	for spooling files
	char					*i_fileBufP;		//	file buffer
	char					*i_basBufP;			//	file buffer for Basic Files (7x size of i_fileBufP)
	
	DiskLocSpecUnion		i_diskLoc;					//	current directory sector
	EntryIndex				i_diskLocDirEntryIndex;		//	relative to cur dir sector
	EntryIndex				i_directoryIndex;			//	relative to entire directory

	Point					i_iconPoint;

	CFinderWindow			*i_window;			//	not NULL if window is open under this folder
	Rect					i_windowRect;		//	contains child window's global coords or 0
	
	O_TopicRef				i_topicRef;				//	some are NULL;
	O_TopicIndex			i_addTopicIndex;	//	location where new file will go
	
	Boolean					i_hilightedB;		//	only for dragging
	
	Boolean					i_badPicB;			//	if get info fails
	
	Boolean					i_myEntryCachedB;

	ulong					i_entryRgnTimestamp;
	RgnHandle				i_entryRgn;
};

#endif
